/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.server.VWFieldUtility;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

final class VWArrayHandler
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7464L;
    private int elementCount = 0;
    private static final int DEFAULT_INITIAL_SIZE = 50;
    private int initialSize = 50;
    private static final int DEFAULT_INCREMENT_SIZE = 25;
    private Class itemClass = null;
    private int incrementSize = 25;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-07-27 01:11:42 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/3 $";
    }

    public VWArrayHandler() {
    }

    public VWArrayHandler(Class theClass) {
        this.itemClass = theClass;
    }

    public VWArrayHandler(int theInitialSize, int theIncrementSize) {
        this.initialSize = theInitialSize;
        this.incrementSize = theIncrementSize;
    }

    public VWArrayHandler(int theInitialSize, int theIncrementSize, Class theClass) {
        this.initialSize = theInitialSize;
        this.incrementSize = theIncrementSize;
        this.itemClass = theClass;
    }

    public Object[] addElementToArray(Object[] theArray, Object theValue) throws VWException {
        Object[] newArray = null;
        int newSize = -1;
        boolean growing = false;
        if (theArray == null) {
            newSize = this.initialSize;
            this.elementCount = 0;
        } else if (this.elementCount == theArray.length) {
            newSize = theArray.length + this.incrementSize;
            growing = true;
        }
        if (newSize != -1) {
            newArray = this.itemClass == null ? (Object[])Array.newInstance(theValue.getClass(), newSize) : (Object[])Array.newInstance(this.itemClass, newSize);
            if (growing) {
                System.arraycopy(theArray, 0, newArray, 0, this.elementCount);
            }
            theArray = newArray;
        }
        theArray[this.elementCount] = theValue;
        ++this.elementCount;
        return theArray;
    }

    public void deleteElementFromArray(Object[] theArray, int theDeleteIndex) throws VWException {
        if (theDeleteIndex < 0 || theDeleteIndex >= this.elementCount) {
            throw new VWException("vw.api.VWArrayHandlerDeleteIndexOutOfBounds", "Attempting to delete using invalid index {0}, count is {1}.", String.valueOf(theDeleteIndex), String.valueOf(this.elementCount));
        }
        for (int index = theDeleteIndex; index < this.elementCount - 1; ++index) {
            theArray[index] = theArray[index + 1];
        }
        theArray[this.elementCount - 1] = null;
        --this.elementCount;
    }

    public void replaceElementInArray(Object[] theArray, Object theValue, int theIndex) throws VWException {
        if (theIndex < 0 || theIndex >= this.elementCount) {
            throw new VWException("vw.api.VWArrayHandlerReplaceIndexOutOfBounds", "Attempting to replace using invalid index {0}, count is {1}.", String.valueOf(theIndex), String.valueOf(this.elementCount));
        }
        theArray[theIndex] = theValue;
    }

    public int getIndexFromStringFieldValue(Object[] theArray, String theFieldName, String theValue) throws VWException {
        if (theValue == null) {
            throw new VWException("vw.api.VWArrayHandlerNoNullMatch", "Cannot search for null value.");
        }
        try {
            Field f = null;
            if (this.elementCount > 0) {
                boolean bFound = false;
                Class<?> theClass = theArray[0].getClass();
                while (!bFound && theClass != null) {
                    try {
                        f = theClass.getDeclaredField(theFieldName);
                        bFound = true;
                    }
                    catch (NoSuchFieldException e) {
                        theClass = theClass.getSuperclass();
                    }
                }
            }
            for (int index = 0; index < this.elementCount; ++index) {
                if (f.get(theArray[index]) == null || !f.get(theArray[index]).equals(theValue)) continue;
                return index;
            }
        }
        catch (Exception e) {
            throw new VWException(e);
        }
        return -1;
    }

    public int getIndexFromIntFieldValue(Object[] theArray, String theFieldName, int theValue) throws VWException {
        try {
            Field f = null;
            if (this.elementCount > 0) {
                boolean bFound = false;
                Class<?> theClass = theArray[0].getClass();
                while (!bFound && theClass != null) {
                    try {
                        f = theClass.getDeclaredField(theFieldName);
                        bFound = true;
                    }
                    catch (NoSuchFieldException e) {
                        theClass = theClass.getSuperclass();
                    }
                }
            }
            for (int index = 0; index < this.elementCount; ++index) {
                if (f.getInt(theArray[index]) != theValue) continue;
                return index;
            }
        }
        catch (Exception e) {
            throw new VWException(e);
        }
        return -1;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public Object[] getElements(Object[] theArray) throws VWException {
        if (this.elementCount <= 0) {
            return null;
        }
        if (theArray == null) {
            throw new VWException("vw.api.VWArrayHandlerInconsistentElementCount", "Element count is {0}, but theArray is null.", String.valueOf(this.elementCount));
        }
        try {
            Object[] rightSizeArray = (Object[])Array.newInstance(theArray.getClass().getComponentType(), this.elementCount);
            System.arraycopy(theArray, 0, rightSizeArray, 0, this.elementCount);
            return rightSizeArray;
        }
        catch (Exception e) {
            throw new VWException(e);
        }
    }

    protected void setElementCount(int theCount) {
        this.elementCount = theCount;
    }

    protected static String convertArrayToString(Object value) throws VWException {
        String theString;
        block15: {
            int arrayCount;
            String quoteChar;
            int theFieldType;
            block13: {
                block16: {
                    block14: {
                        if (value == null) {
                            return null;
                        }
                        if (!value.getClass().isArray()) {
                            return null;
                        }
                        theString = "{";
                        theFieldType = VWFieldType.getVWFieldType(value);
                        quoteChar = "";
                        if (theFieldType == 64 || theFieldType == 32 || theFieldType == 16 || theFieldType == 256 || theFieldType == 512) {
                            quoteChar = "\"";
                        }
                        if ((arrayCount = ((Object[])value).length) > 0 && (arrayCount != 1 || ((Object[])value)[0] != null)) break block13;
                        if (theFieldType != 64 && theFieldType != 32 && theFieldType != 16 && theFieldType != 256 && theFieldType != 2 && theFieldType != 512) break block14;
                        theString = theString + quoteChar + quoteChar;
                        break block15;
                    }
                    if (theFieldType != 4) break block16;
                    theString = theString + "true";
                    break block15;
                }
                if (theFieldType != 8 && theFieldType != 1) break block15;
                theString = theString + "0";
                break block15;
            }
            if (arrayCount > 0) {
                if (theFieldType == 64 || theFieldType == 32 || theFieldType == 512) {
                    theString = theString + quoteChar + (((Object[])value)[0] != null ? ((Object[])value)[0].toString() : "") + quoteChar;
                } else if (theFieldType == 16 || theFieldType == 256) {
                    theString = theString + quoteChar + VWFieldUtility.convertDateToString(((Object[])value)[0]) + quoteChar;
                } else {
                    if (((Object[])value)[0] == null) {
                        throw new VWException("vw.api.VWArrayHandlerArrayHasNullsToString", "Attempt to convert an array containing nulls to a string");
                    }
                    theString = theString + ((Object[])value)[0].toString();
                }
                for (int loop = 1; loop < arrayCount; ++loop) {
                    if (theFieldType == 64 || theFieldType == 32 || theFieldType == 512) {
                        theString = theString + "," + quoteChar + ((Object[])value)[loop].toString() + quoteChar;
                        continue;
                    }
                    if (theFieldType == 16 || theFieldType == 256) {
                        theString = theString + "," + quoteChar + VWFieldUtility.convertDateToString(((Object[])value)[loop]) + quoteChar;
                        continue;
                    }
                    if (((Object[])value)[loop] == null) {
                        throw new VWException("vw.api.VWArrayHandlerArrayHasNullsToString", "Attempt to convert an array containing nulls to a string");
                    }
                    theString = theString + "," + ((Object[])value)[loop].toString();
                }
            }
        }
        theString = theString + "}";
        return theString;
    }

    protected static String runtimeConvertArrayToString(Object value) throws VWException {
        String theString;
        block15: {
            int arrayCount;
            String quoteChar;
            int theFieldType;
            block13: {
                block16: {
                    block14: {
                        if (value == null) {
                            return null;
                        }
                        if (!value.getClass().isArray()) {
                            return null;
                        }
                        theString = "{";
                        theFieldType = VWFieldType.getVWFieldType(value);
                        quoteChar = "";
                        if (theFieldType == 32 || theFieldType == 16 || theFieldType == 256 || theFieldType == 512) {
                            quoteChar = "\"";
                        }
                        if ((arrayCount = ((Object[])value).length) > 0 && (arrayCount != 1 || ((Object[])value)[0] != null)) break block13;
                        if (theFieldType != 32 && theFieldType != 16 && theFieldType != 256 && theFieldType != 2 && theFieldType != 512) break block14;
                        theString = theString + quoteChar + quoteChar;
                        break block15;
                    }
                    if (theFieldType != 4) break block16;
                    theString = theString + "true";
                    break block15;
                }
                if (theFieldType != 8 && theFieldType != 1) break block15;
                theString = theString + "0";
                break block15;
            }
            if (arrayCount > 0) {
                if (theFieldType == 64 || theFieldType == 32 || theFieldType == 512) {
                    theString = theString + quoteChar + (((Object[])value)[0] != null ? ((Object[])value)[0].toString() : "") + quoteChar;
                } else if (theFieldType == 16 || theFieldType == 256) {
                    theString = theString + quoteChar + VWFieldUtility.convertDateToString(((Object[])value)[0]) + quoteChar;
                } else {
                    if (((Object[])value)[0] == null) {
                        throw new VWException("vw.api.VWArrayHandlerArrayHasNullsToString", "Attempt to convert an array containing nulls to a string");
                    }
                    theString = theString + ((Object[])value)[0].toString();
                }
                for (int loop = 1; loop < arrayCount; ++loop) {
                    if (theFieldType == 64 || theFieldType == 32 || theFieldType == 512) {
                        theString = theString + "," + quoteChar + ((Object[])value)[loop].toString() + quoteChar;
                        continue;
                    }
                    if (theFieldType == 16 || theFieldType == 256) {
                        theString = theString + "," + quoteChar + VWFieldUtility.convertDateToString(((Object[])value)[loop]) + quoteChar;
                        continue;
                    }
                    if (((Object[])value)[loop] == null) {
                        throw new VWException("vw.api.VWArrayHandlerArrayHasNullsToString", "Attempt to convert an array containing nulls to a string");
                    }
                    theString = theString + "," + ((Object[])value)[loop].toString();
                }
            }
        }
        theString = theString + "}";
        return theString;
    }

    protected Object clone() {
        try {
            VWArrayHandler arrayHandler = (VWArrayHandler)super.clone();
            return arrayHandler;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

